/*! \file tlk_cert_api_pkcs10.h 
**********************************************************************************
*Title:                         Discretix Certificate Handling Toolkit source file
*
* Filename:                     tlk_cert_api_pkcs10.h 
*
* Project, Target, subsystem:   Toolkit, Certificate Handling, IEEE 1667 Adaptation
* 
* Created:                      11.02.2009
*
* Modified:                     11.02.2009
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_CERT_API_PKCS10_H_
#define _TLK_CERT_API_PKCS10_H_

#include "tlk_cert_types.h"
#ifdef __cplusplus
extern "C"
{
#endif

#define TLK_CERT_PKCS10_REQUEST_SIZE_MIN_IN_BYTES   (500)

/*TLK_CERT_PKCS10_RequestCreate*/
/**
* @brief    This function generates response in PKCS #10 standard.
*           The request will be built according to the following ASN.1 
*
*        CertificationRequest ::= SEQUENCE {
*           certificationRequestInfo CertificationRequestInfo,
*           signatureAlgorithm AlgorithmIdentifier{{ SignatureAlgorithms }},
*           signature          BIT STRING
*        }
*
*        CertificationRequestInfo ::= SEQUENCE {
*            version       INTEGER { v1(0) } (v1,...),
*            subject       Name,
*            subjectPKInfo SubjectPublicKeyInfo{{ PKInfoAlgorithms }},
*            attributes    [0] Attributes{{ CRIAttributes }}
*        }
*
*        SubjectPublicKeyInfo { ALGORITHM : IOSet} ::= SEQUENCE {
*            algorithm        AlgorithmIdentifier {{IOSet}},
*            subjectPublicKey BIT STRING
*        }
*
*       PKInfoAlgorithms ALGORITHM ::= {
*           ...  -- add any locally defined algorithms here -- }
*
*       Attributes { ATTRIBUTE:IOSet } ::= SET OF Attribute{{ IOSet }}
*
*       CRIAttributes  ATTRIBUTE  ::= {
*           ... -- add any locally defined attributes here -- }
*
*       Attribute { ATTRIBUTE:IOSet } ::= SEQUENCE {
*           type   ATTRIBUTE.&id({IOSet}),
*           values SET SIZE(1..MAX) OF ATTRIBUTE.&Type({IOSet}{@type})
*    }
*
*
* @param requestCreateParams_ptr   [in]      - necessary parameters structure which user have fill before request creation
*                                              versionNumber      - Version number (available version numbers are v0, v1, v2, v3)
*                                              subjectName        - Subject name  (Note: always in UTF-8 format)
*                                              subjectPKInfo      - Subject public key format
*                                              attributes         - Attributes  (Note: always in UTF-8 format)
* @param request_ptr               [out]     - Pointer to the response
* @param workspace_ptr             [in]      - Pointer to the workspace. Note: The user is responsible for workspace allocation.
* @param workspaceSizeInBytes      [in]      - Length of the workspace in bytes

* @return TLK_CERT_RC_OK                                            - The operation completed successfully.
* @return TLK_CERT_RC_ERROR_API_NULL_POINTER                        - Null pointer received as input
*/
DxError_t TLK_CERT_PKCS10_RequestCreate(  TLK_CERT_PKCS10_RequestCreateParams_t   *requestCreateParams_ptr,
                                          TLK_CERT_Buffer_t                       *request_ptr,
                                          DxUint8_t                               *workspace_ptr,
                                          DxUint32_t                               workspaceSizeInBytes);

#ifdef __cplusplus
}
#endif /*extern "C"*/
#endif

